/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.soo.dtoc;

import com.ibm.hwmca.fw.soo.dtoc.DTOCClientException;
import com.ibm.hwmca.fw.soo.dtoc.master;
import java.awt.Frame;
import java.awt.Panel;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;

public class DTOCClient {
    public static final int HMC_ENVIRONMENT = 1;
    public static final int NON_HMC_ENVIRONMENT = 2;
    public static final int DT_ENVIRONMENT = 3;
    public static final int DEFAULT_SERVER_PORT = 25345;
    public static final int MAX_TRACE_LEVEL = 3;
    public static final int DEFAULT_TRACE_LEVEL = 0;
    int traceLevel = 0;
    protected master mainPanel;
    protected int environment;
    protected Frame frame;
    protected Thread runner;
    protected boolean connected = false;
    private static final String TRACE_MASKT = "XDTCCLTT";
    private static final String TRACE_MASKF = "XDTCCLTF";
    private static final String TRACE_MASKD = "XDTCCLTD";

    public DTOCClient(int environmentType) {
        this.environment = environmentType;
        this.mainPanel = new master(this);
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public DTOCClient() {
        this(2);
    }

    public Panel getMainPanel() {
        return this.mainPanel;
    }

    public int getEnvironment() {
        return this.environment;
    }

    public void connect(InetAddress serverAddress, int serverPort, String remoteUserid, char[] remotePassword) throws DTOCClientException {
        this.trace(1, TRACE_MASKT, "-> connect() for non-HMC environment");
        this.connect(serverAddress, serverPort, remoteUserid, remotePassword, null, null, null, (short)-1);
        this.trace(1, TRACE_MASKT, "<- connect() for non-HMC environment");
    }

    public void connect(InetAddress serverAddress, int serverPort, String remoteUserid, char[] remotePassword, String HMCNetId, String HMCNAU, String HMCUserid, short HMCUserMode) throws DTOCClientException {
        this.trace(1, TRACE_MASKT, "-> connect");
        this.trace(2, TRACE_MASKF, "DTOCClient.connect() about to call master.connect(" + serverAddress + ", " + serverPort + ", " + remoteUserid + ", <some_pwd>)" + ", " + HMCNetId + ", " + HMCNAU + ", " + HMCUserid + ", " + HMCUserMode);
        this.trace(3, TRACE_MASKD, "Password=" + (remotePassword == null ? "null" : String.valueOf(remotePassword)));
        if (this.connected) {
            throw new DTOCClientException("Already connected");
        }
        if (!this.mainPanel.connect(serverAddress.getHostAddress(), serverPort, remoteUserid, remotePassword, HMCNetId, HMCNAU, HMCUserid, HMCUserMode)) {
            String reason = this.mainPanel.getConnectFailureMessage();
            throw new DTOCClientException("Unable to connect or login to target machine" + (reason == null ? "." : ": " + reason));
        }
        this.connected = true;
        this.trace(1, TRACE_MASKT, "<- connect");
    }

    public void connect(Socket serverSocket, String remoteUserid, char[] remotePassword, String HMCNetId, String HMCNAU, String HMCUserid, short HMCUserMode) throws DTOCClientException {
        this.trace(1, TRACE_MASKT, "-> connect");
        this.trace(2, TRACE_MASKF, "DTOCClient.connect() about to call master.connect(" + serverSocket + ", " + remoteUserid + ", <some_pwd>)" + ", " + HMCNetId + ", " + HMCNAU + ", " + HMCUserid + ", " + HMCUserMode);
        this.trace(3, TRACE_MASKD, "Password=" + (remotePassword == null ? "null" : String.valueOf(remotePassword)));
        if (this.connected) {
            throw new DTOCClientException("Already connected");
        }
        if (!this.mainPanel.connect(serverSocket, remoteUserid, remotePassword, HMCNetId, HMCNAU, HMCUserid, HMCUserMode)) {
            String reason = this.mainPanel.getConnectFailureMessage();
            throw new DTOCClientException("Unable to connect or login to target machine" + (reason == null ? "." : ": " + reason));
        }
        this.connected = true;
        this.trace(1, TRACE_MASKT, "<- connect");
    }

    public void connect(InputStream input, OutputStream output, String remoteUserid, char[] remotePassword, String HMCNetId, String HMCNAU, String HMCUserid, short HMCUserMode) throws DTOCClientException {
        this.trace(1, TRACE_MASKT, "-> connect");
        this.trace(2, TRACE_MASKF, "DTOCClient.connect() about to call master.connect(" + input + ", " + output + ", " + remoteUserid + ", <some_pwd>)" + ", " + HMCNetId + ", " + HMCNAU + ", " + HMCUserid + ", " + HMCUserMode);
        this.trace(3, TRACE_MASKD, "Password=" + (remotePassword == null ? "null" : String.valueOf(remotePassword)));
        if (this.connected) {
            throw new DTOCClientException("Already connected");
        }
        if (!this.mainPanel.connect(input, output, remoteUserid, remotePassword, HMCNetId, HMCNAU, HMCUserid, HMCUserMode)) {
            String reason = this.mainPanel.getConnectFailureMessage();
            throw new DTOCClientException("Unable to connect or login to target machine" + (reason == null ? "." : ": " + reason));
        }
        this.connected = true;
        this.trace(1, TRACE_MASKT, "<- connect");
    }

    public void start() {
        this.trace(1, TRACE_MASKT, "-> start");
        this.trace(2, TRACE_MASKF, "DTOCClient.start() about to call master.start()");
        this.mainPanel.start();
        this.trace(2, TRACE_MASKF, "DTOCClient.start() about to start 'master' thread.");
        this.runner = new Thread(this.mainPanel);
        this.runner.start();
        this.trace(1, TRACE_MASKT, "<- start");
    }

    public void stop() {
        this.trace(1, TRACE_MASKT, "-> stop");
        this.mainPanel.disconnect();
        this.connected = false;
        this.trace(1, TRACE_MASKT, "<- stop");
    }

    public void dispose() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    public void sendCTLESC() {
        this.sendSpecialKeySequence(27, 2);
    }

    public void sendALTESC() {
        this.sendSpecialKeySequence(27, 8);
    }

    public void sendALTTAB() {
        this.sendSpecialKeySequence(9, 8);
    }

    private void sendSpecialKeySequence(int keyCode, int modifiers) {
        this.trace(1, TRACE_MASKT, "-> sendSpecialKeySequence(" + keyCode + "," + modifiers + ")");
        this.mainPanel.myKeyPress(keyCode, 65535, modifiers);
        this.mainPanel.myKeyRelease(keyCode, 65535, modifiers);
        this.trace(1, TRACE_MASKT, "<- sendSpecialKeySequence");
    }

    public boolean isConnected() {
        return this.mainPanel.isConnected();
    }

    public void setTraceLevel(int level) throws DTOCClientException {
        this.trace(1, TRACE_MASKT, "-> setTraceLevel");
        if (level < 0 || level > 3) {
            throw new DTOCClientException("Invalid trace level; must be between 0 and 3, inclusive.");
        }
        this.traceLevel = level;
        this.trace(1, TRACE_MASKT, "<- setTraceLevel");
    }

    public void trace(int level, String mask, String text) {
        if (level <= this.traceLevel) {
            System.out.println((mask != null ? mask + " " : "") + text);
        }
    }
}

